%------------------------------------------------------------------------------
% File     : DAT205^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Sorted list operations 194
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Lam09] Lammich (2009), Collections Framework
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : sorted_list_operations__194.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.1.0
% Syntax   : Number of formulae    :  320 ( 101 unt;  46 typ;   0 def)
%            Number of atoms       :  802 ( 405 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 4422 ( 150   ~;  17   |;  95   &;3753   @)
%                                         (   0 <=>; 407  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   25 (   8 avg)
%            Number of types       :    2 (   1 usr)
%            Number of type conns  :  180 ( 180   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   48 (  45 usr;   8 con; 0-4 aty)
%            Number of variables   : 1118 (  22   ^; 992   !;  66   ?;1118   :)
%                                         (  38  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:41:06.808
%------------------------------------------------------------------------------
%----Could-be-implicit typings (4)
thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (42)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Obind,type,
    bind: 
      !>[A: $tType,B: $tType] : ( ( list @ A ) > ( A > ( list @ B ) ) > ( list @ B ) ) ).

thf(sy_c_List_Obutlast,type,
    butlast: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Ocan__select,type,
    can_select: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) > $o ) ).

thf(sy_c_List_Ocoset,type,
    coset: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olast,type,
    last: 
      !>[A: $tType] : ( ( list @ A ) > A ) ).

thf(sy_c_List_Olinorder__class_Osorted,type,
    linorder_sorted: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olist_Ohd,type,
    hd: 
      !>[A: $tType] : ( ( list @ A ) > A ) ).

thf(sy_c_List_Olist_Oset,type,
    set2: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Olist_Otl,type,
    tl: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( A > ( list @ B ) ) > ( list @ A ) > ( list @ B ) ) ).

thf(sy_c_List_Omember,type,
    member: 
      !>[A: $tType] : ( ( list @ A ) > A > $o ) ).

thf(sy_c_List_Oproduct__lists,type,
    product_lists: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Osublists,type,
    sublists: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Ounion,type,
    union: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List__More_Ocombinatorial__product,type,
    list_c659805718roduct: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_Misc_Omergesort__remdups,type,
    mergesort_remdups: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oremove,type,
    remove: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_Sorted__List__Operations__Mirabelle__fineeiboro_Osubset__sorted,type,
    sorted1061247458sorted: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > $o ) ).

thf(sy_c_member,type,
    member2: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_l1,type,
    l1: list @ a ).

thf(sy_v_l1a____,type,
    l1a: list @ a ).

thf(sy_v_l2,type,
    l2: list @ a ).

thf(sy_v_l2b____,type,
    l2b: list @ a ).

thf(sy_v_x1____,type,
    x1: a ).

thf(sy_v_x2____,type,
    x2: a ).

%----Relevant facts (255)
thf(fact_0_x1__nin__l1,axiom,
    ~ ( member2 @ a @ x1 @ ( set2 @ a @ l1a ) ) ).

% x1_nin_l1
thf(fact_1_x2__nin__l2,axiom,
    ~ ( member2 @ a @ x2 @ ( set2 @ a @ l2b ) ) ).

% x2_nin_l2
thf(fact_2_ind__hyp__l2,axiom,
    ( ( sorted1061247458sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b )
    = ( ord_less_eq @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ l2b ) ) ) ).

% ind_hyp_l2
thf(fact_3_x2__le,axiom,
    ! [X: a] :
      ( ( member2 @ a @ X @ ( set2 @ a @ l2b ) )
     => ( ord_less_eq @ a @ x2 @ X ) ) ).

% x2_le
thf(fact_4_x1__le,axiom,
    ! [X: a] :
      ( ( member2 @ a @ X @ ( set2 @ a @ l1a ) )
     => ( ord_less_eq @ a @ x1 @ X ) ) ).

% x1_le
thf(fact_5_Cons_Ohyps,axiom,
    ( ( ( distinct @ a @ l2b )
      & ( linorder_sorted @ a @ l2b ) )
   => ( ( sorted1061247458sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b )
      = ( ord_less_eq @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ l2b ) ) ) ) ).

% Cons.hyps
thf(fact_6_set__subset__Cons,axiom,
    ! [A: $tType,Xs: list @ A,X: A] : ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ ( cons @ A @ X @ Xs ) ) ) ).

% set_subset_Cons
thf(fact_7_subsetI,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ! [X2: A] :
          ( ( member2 @ A @ X2 @ A2 )
         => ( member2 @ A @ X2 @ B2 ) )
     => ( ord_less_eq @ ( set @ A ) @ A2 @ B2 ) ) ).

% subsetI
thf(fact_8_subset__antisym,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ A2 )
       => ( A2 = B2 ) ) ) ).

% subset_antisym
thf(fact_9_list_Oinject,axiom,
    ! [A: $tType,X21: A,X22: list @ A,Y21: A,Y22: list @ A] :
      ( ( ( cons @ A @ X21 @ X22 )
        = ( cons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 ) ) ) ).

% list.inject
thf(fact_10_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_11_subset__code_I1_J,axiom,
    ! [A: $tType,Xs: list @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ B2 )
      = ( ! [X3: A] :
            ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
           => ( member2 @ A @ X3 @ B2 ) ) ) ) ).

% subset_code(1)
thf(fact_12_list_Oset__intros_I2_J,axiom,
    ! [A: $tType,X: A,A22: list @ A,A1: A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ A22 ) )
     => ( member2 @ A @ X @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ) ).

% list.set_intros(2)
thf(fact_13_list_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A22: list @ A] : ( member2 @ A @ A1 @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ).

% list.set_intros(1)
thf(fact_14_set__ConsD,axiom,
    ! [A: $tType,Y: A,X: A,Xs: list @ A] :
      ( ( member2 @ A @ Y @ ( set2 @ A @ ( cons @ A @ X @ Xs ) ) )
     => ( ( Y = X )
        | ( member2 @ A @ Y @ ( set2 @ A @ Xs ) ) ) ) ).

% set_ConsD
thf(fact_15_l1__OK,axiom,
    ( ( distinct @ a @ l1 )
    & ( linorder_sorted @ a @ l1 ) ) ).

% l1_OK
thf(fact_16_l2__OK,axiom,
    ( ( distinct @ a @ l2 )
    & ( linorder_sorted @ a @ l2 ) ) ).

% l2_OK
thf(fact_17_x1__l1__props,axiom,
    ( ( distinct @ a @ ( cons @ a @ x1 @ l1a ) )
    & ( linorder_sorted @ a @ ( cons @ a @ x1 @ l1a ) ) ) ).

% x1_l1_props
thf(fact_18_x2__l2__props,axiom,
    ( ( distinct @ a @ ( cons @ a @ x2 @ l2b ) )
    & ( linorder_sorted @ a @ ( cons @ a @ x2 @ l2b ) ) ) ).

% x2_l2_props
thf(fact_19_l2__props,axiom,
    ( ( distinct @ a @ l2b )
    & ( linorder_sorted @ a @ l2b ) ) ).

% l2_props
thf(fact_20_l1__props,axiom,
    ( ( distinct @ a @ l1a )
    & ( linorder_sorted @ a @ l1a ) ) ).

% l1_props
thf(fact_21_ind__hyp__l1,axiom,
    ! [L2: list @ a] :
      ( ( ( distinct @ a @ L2 )
        & ( linorder_sorted @ a @ L2 ) )
     => ( ( sorted1061247458sorted @ a @ l1a @ L2 )
        = ( ord_less_eq @ ( set @ a ) @ ( set2 @ a @ l1a ) @ ( set2 @ a @ L2 ) ) ) ) ).

% ind_hyp_l1
thf(fact_22_sorted__many__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Zs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X @ ( cons @ A @ Y @ Zs ) ) )
          = ( ( ord_less_eq @ A @ X @ Y )
            & ( linorder_sorted @ A @ ( cons @ A @ Y @ Zs ) ) ) ) ) ).

% sorted_many_eq
thf(fact_23_sorted__distinct__set__unique,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Ys: list @ A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ( distinct @ A @ Xs )
           => ( ( linorder_sorted @ A @ Ys )
             => ( ( distinct @ A @ Ys )
               => ( ( ( set2 @ A @ Xs )
                    = ( set2 @ A @ Ys ) )
                 => ( Xs = Ys ) ) ) ) ) ) ) ).

% sorted_distinct_set_unique
thf(fact_24_distinct__length__2__or__more,axiom,
    ! [A: $tType,A3: A,B3: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ A3 @ ( cons @ A @ B3 @ Xs ) ) )
      = ( ( A3 != B3 )
        & ( distinct @ A @ ( cons @ A @ A3 @ Xs ) )
        & ( distinct @ A @ ( cons @ A @ B3 @ Xs ) ) ) ) ).

% distinct_length_2_or_more
thf(fact_25_sorted__many,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Zs: list @ A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( linorder_sorted @ A @ ( cons @ A @ Y @ Zs ) )
           => ( linorder_sorted @ A @ ( cons @ A @ X @ ( cons @ A @ Y @ Zs ) ) ) ) ) ) ).

% sorted_many
thf(fact_26_distinct_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ X @ Xs ) )
      = ( ~ ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
        & ( distinct @ A @ Xs ) ) ) ).

% distinct.simps(2)
thf(fact_27_sorted__Cons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Xs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X @ Xs ) )
          = ( ( linorder_sorted @ A @ Xs )
            & ! [X3: A] :
                ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ X @ X3 ) ) ) ) ) ).

% sorted_Cons
thf(fact_28_sorted_OCons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,X: A] :
          ( ! [X2: A] :
              ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
             => ( ord_less_eq @ A @ X @ X2 ) )
         => ( ( linorder_sorted @ A @ Xs )
           => ( linorder_sorted @ A @ ( cons @ A @ X @ Xs ) ) ) ) ) ).

% sorted.Cons
thf(fact_29_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ A3 @ B3 )
           => ( A3 = B3 ) ) ) ) ).

% dual_order.antisym
thf(fact_30_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ C @ B3 )
           => ( ord_less_eq @ A @ C @ A3 ) ) ) ) ).

% dual_order.trans
thf(fact_31_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A3: A,B3: A] :
          ( ! [A4: A,B4: A] :
              ( ( ord_less_eq @ A @ A4 @ B4 )
             => ( P @ A4 @ B4 ) )
         => ( ! [A4: A,B4: A] :
                ( ( P @ B4 @ A4 )
               => ( P @ A4 @ B4 ) )
           => ( P @ A3 @ B3 ) ) ) ) ).

% linorder_wlog
thf(fact_32_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A] : ( ord_less_eq @ A @ A3 @ A3 ) ) ).

% dual_order.refl
thf(fact_33_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z )
           => ( ord_less_eq @ A @ X @ Z ) ) ) ) ).

% order_trans
thf(fact_34_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ A3 )
           => ( A3 = B3 ) ) ) ) ).

% order_class.order.antisym
thf(fact_35_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( B3 = C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_36_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( A3 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_37_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( ord_less_eq @ A @ X @ Y )
            = ( X = Y ) ) ) ) ).

% antisym_conv
thf(fact_38_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ( ord_less_eq @ A @ X @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z ) )
         => ( ( ( ord_less_eq @ A @ Y @ X )
             => ~ ( ord_less_eq @ A @ X @ Z ) )
           => ( ( ( ord_less_eq @ A @ X @ Z )
               => ~ ( ord_less_eq @ A @ Z @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z )
                   => ~ ( ord_less_eq @ A @ Z @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_39_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% order.trans
thf(fact_40_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y )
         => ( ord_less_eq @ A @ Y @ X ) ) ) ).

% le_cases
thf(fact_41_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X = Y )
         => ( ord_less_eq @ A @ X @ Y ) ) ) ).

% eq_refl
thf(fact_42_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
          | ( ord_less_eq @ A @ Y @ X ) ) ) ).

% linear
thf(fact_43_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ X )
           => ( X = Y ) ) ) ) ).

% antisym
thf(fact_44_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y2: A,Z2: A] : ( Y2 = Z2 ) )
        = ( ^ [X3: A,Y3: A] :
              ( ( ord_less_eq @ A @ X3 @ Y3 )
              & ( ord_less_eq @ A @ Y3 @ X3 ) ) ) ) ) ).

% eq_iff
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A3: A,P: A > $o] :
      ( ( member2 @ A @ A3 @ ( collect @ A @ P ) )
      = ( P @ A3 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( collect @ A
        @ ^ [X3: A] : ( member2 @ A @ X3 @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X2: A] :
          ( ( P @ X2 )
          = ( Q @ X2 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F: A > B,C: B] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ( F @ B3 )
              = C )
           => ( ! [X2: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y4 )
                 => ( ord_less_eq @ B @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ B @ ( F @ A3 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_49_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F: B > A,B3: B,C: B] :
          ( ( A3
            = ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C )
           => ( ! [X2: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X2 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A3 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_50_order__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 @ ( type2 @ C2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F: A > C2,C: C2] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ C2 @ ( F @ B3 ) @ C )
           => ( ! [X2: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y4 )
                 => ( ord_less_eq @ C2 @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ C2 @ ( F @ A3 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_51_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F: B > A,B3: B,C: B] :
          ( ( ord_less_eq @ A @ A3 @ ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C )
           => ( ! [X2: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X2 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A3 @ ( F @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_52_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F2: A > B,G: A > B] :
            ! [X3: A] : ( ord_less_eq @ B @ ( F2 @ X3 ) @ ( G @ X3 ) ) ) ) ) ).

% le_fun_def
thf(fact_53_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G2: A > B] :
          ( ! [X2: A] : ( ord_less_eq @ B @ ( F @ X2 ) @ ( G2 @ X2 ) )
         => ( ord_less_eq @ ( A > B ) @ F @ G2 ) ) ) ).

% le_funI
thf(fact_54_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G2: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G2 )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G2 @ X ) ) ) ) ).

% le_funE
thf(fact_55_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G2: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G2 )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G2 @ X ) ) ) ) ).

% le_funD
thf(fact_56_not__Cons__self2,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( cons @ A @ X @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_57_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X3: A] :
            ( ( P @ X3 )
           => ( Q @ X3 ) ) ) ) ).

% Collect_mono_iff
thf(fact_58_contra__subsetD,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ~ ( member2 @ A @ C @ B2 )
       => ~ ( member2 @ A @ C @ A2 ) ) ) ).

% contra_subsetD
thf(fact_59_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y2: set @ A,Z2: set @ A] : ( Y2 = Z2 ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A5 @ B5 )
            & ( ord_less_eq @ ( set @ A ) @ B5 @ A5 ) ) ) ) ).

% set_eq_subset
thf(fact_60_subset__trans,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C3: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ C3 )
       => ( ord_less_eq @ ( set @ A ) @ A2 @ C3 ) ) ) ).

% subset_trans
thf(fact_61_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X2: A] :
          ( ( P @ X2 )
         => ( Q @ X2 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_62_subset__refl,axiom,
    ! [A: $tType,A2: set @ A] : ( ord_less_eq @ ( set @ A ) @ A2 @ A2 ) ).

% subset_refl
thf(fact_63_rev__subsetD,axiom,
    ! [A: $tType,C: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ C @ A2 )
     => ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
       => ( member2 @ A @ C @ B2 ) ) ) ).

% rev_subsetD
thf(fact_64_subset__iff,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
          ! [T: A] :
            ( ( member2 @ A @ T @ A5 )
           => ( member2 @ A @ T @ B5 ) ) ) ) ).

% subset_iff
thf(fact_65_set__rev__mp,axiom,
    ! [A: $tType,X: A,A2: set @ A,B2: set @ A] :
      ( ( member2 @ A @ X @ A2 )
     => ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
       => ( member2 @ A @ X @ B2 ) ) ) ).

% set_rev_mp
thf(fact_66_equalityD2,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( A2 = B2 )
     => ( ord_less_eq @ ( set @ A ) @ B2 @ A2 ) ) ).

% equalityD2
thf(fact_67_equalityD1,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( A2 = B2 )
     => ( ord_less_eq @ ( set @ A ) @ A2 @ B2 ) ) ).

% equalityD1
thf(fact_68_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
          ! [X3: A] :
            ( ( member2 @ A @ X3 @ A5 )
           => ( member2 @ A @ X3 @ B5 ) ) ) ) ).

% subset_eq
thf(fact_69_equalityE,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A] :
      ( ( A2 = B2 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
         => ~ ( ord_less_eq @ ( set @ A ) @ B2 @ A2 ) ) ) ).

% equalityE
thf(fact_70_subsetCE,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( member2 @ A @ C @ A2 )
       => ( member2 @ A @ C @ B2 ) ) ) ).

% subsetCE
thf(fact_71_subsetD,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( member2 @ A @ C @ A2 )
       => ( member2 @ A @ C @ B2 ) ) ) ).

% subsetD
thf(fact_72_in__mono,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( member2 @ A @ X @ A2 )
       => ( member2 @ A @ X @ B2 ) ) ) ).

% in_mono
thf(fact_73_set__mp,axiom,
    ! [A: $tType,A2: set @ A,B2: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B2 )
     => ( ( member2 @ A @ X @ A2 )
       => ( member2 @ A @ X @ B2 ) ) ) ).

% set_mp
thf(fact_74_list_Oset__cases,axiom,
    ! [A: $tType,E: A,A3: list @ A] :
      ( ( member2 @ A @ E @ ( set2 @ A @ A3 ) )
     => ( ! [Z22: list @ A] :
            ( A3
           != ( cons @ A @ E @ Z22 ) )
       => ~ ! [Z1: A,Z22: list @ A] :
              ( ( A3
                = ( cons @ A @ Z1 @ Z22 ) )
             => ~ ( member2 @ A @ E @ ( set2 @ A @ Z22 ) ) ) ) ) ).

% list.set_cases
thf(fact_75_distinct__union,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( distinct @ A @ ( union @ A @ Xs @ Ys ) )
      = ( distinct @ A @ Ys ) ) ).

% distinct_union
thf(fact_76_not__in__set__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ~ ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X @ Xs )
        = ( cons @ A @ X @ Xs ) ) ) ).

% not_in_set_insert
thf(fact_77_sorted_Oinducts,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: list @ A,P: ( list @ A ) > $o] :
          ( ( linorder_sorted @ A @ X )
         => ( ( P @ ( nil @ A ) )
           => ( ! [Xs2: list @ A,X2: A] :
                  ( ! [Xa: A] :
                      ( ( member2 @ A @ Xa @ ( set2 @ A @ Xs2 ) )
                     => ( ord_less_eq @ A @ X2 @ Xa ) )
                 => ( ( linorder_sorted @ A @ Xs2 )
                   => ( ( P @ Xs2 )
                     => ( P @ ( cons @ A @ X2 @ Xs2 ) ) ) ) )
             => ( P @ X ) ) ) ) ) ).

% sorted.inducts
thf(fact_78_sorted_Osimps,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ( linorder_sorted @ A )
        = ( ^ [A6: list @ A] :
              ( ( A6
                = ( nil @ A ) )
              | ? [Xs3: list @ A,X3: A] :
                  ( ( A6
                    = ( cons @ A @ X3 @ Xs3 ) )
                  & ! [Y3: A] :
                      ( ( member2 @ A @ Y3 @ ( set2 @ A @ Xs3 ) )
                     => ( ord_less_eq @ A @ X3 @ Y3 ) )
                  & ( linorder_sorted @ A @ Xs3 ) ) ) ) ) ) ).

% sorted.simps
thf(fact_79_sorted_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A3: list @ A] :
          ( ( linorder_sorted @ A @ A3 )
         => ( ( A3
             != ( nil @ A ) )
           => ~ ! [Xs2: list @ A,X2: A] :
                  ( ( A3
                    = ( cons @ A @ X2 @ Xs2 ) )
                 => ( ! [Xa: A] :
                        ( ( member2 @ A @ Xa @ ( set2 @ A @ Xs2 ) )
                       => ( ord_less_eq @ A @ X2 @ Xa ) )
                   => ~ ( linorder_sorted @ A @ Xs2 ) ) ) ) ) ) ).

% sorted.cases
thf(fact_80_mergesort__remdups__correct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L: list @ A] :
          ( ( distinct @ A @ ( mergesort_remdups @ A @ L ) )
          & ( linorder_sorted @ A @ ( mergesort_remdups @ A @ L ) )
          & ( ( set2 @ A @ ( mergesort_remdups @ A @ L ) )
            = ( set2 @ A @ L ) ) ) ) ).

% mergesort_remdups_correct
thf(fact_81_List_Oinsert__def,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [X3: A,Xs3: list @ A] : ( if @ ( list @ A ) @ ( member2 @ A @ X3 @ ( set2 @ A @ Xs3 ) ) @ Xs3 @ ( cons @ A @ X3 @ Xs3 ) ) ) ) ).

% List.insert_def
thf(fact_82_subset__code_I2_J,axiom,
    ! [B: $tType,A2: set @ B,Ys: list @ B] :
      ( ( ord_less_eq @ ( set @ B ) @ A2 @ ( coset @ B @ Ys ) )
      = ( ! [X3: B] :
            ( ( member2 @ B @ X3 @ ( set2 @ B @ Ys ) )
           => ~ ( member2 @ B @ X3 @ A2 ) ) ) ) ).

% subset_code(2)
thf(fact_83_subset__Collect__conv,axiom,
    ! [A: $tType,S: set @ A,P: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ S @ ( collect @ A @ P ) )
      = ( ! [X3: A] :
            ( ( member2 @ A @ X3 @ S )
           => ( P @ X3 ) ) ) ) ).

% subset_Collect_conv
thf(fact_84_in__set__member,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
      = ( member @ A @ Xs @ X ) ) ).

% in_set_member
thf(fact_85_in__set__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X @ Xs )
        = Xs ) ) ).

% in_set_insert
thf(fact_86_distinct__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( distinct @ A @ ( insert @ A @ X @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct_insert
thf(fact_87_sorted__single,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( linorder_sorted @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) ) ).

% sorted_single
thf(fact_88_insert__Nil,axiom,
    ! [A: $tType,X: A] :
      ( ( insert @ A @ X @ ( nil @ A ) )
      = ( cons @ A @ X @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_89_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] :
      ~ ( member @ A @ ( nil @ A ) @ Y ) ).

% member_rec(2)
thf(fact_90_transpose_Ocases,axiom,
    ! [A: $tType,X: list @ ( list @ A )] :
      ( ( X
       != ( nil @ ( list @ A ) ) )
     => ( ! [Xss: list @ ( list @ A )] :
            ( X
           != ( cons @ ( list @ A ) @ ( nil @ A ) @ Xss ) )
       => ~ ! [X2: A,Xs2: list @ A,Xss: list @ ( list @ A )] :
              ( X
             != ( cons @ ( list @ A ) @ ( cons @ A @ X2 @ Xs2 ) @ Xss ) ) ) ) ).

% transpose.cases
thf(fact_91_revg_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
     => ( ! [A4: A,As: list @ A,B4: list @ A] :
            ( ( P @ As @ ( cons @ A @ A4 @ B4 ) )
           => ( P @ ( cons @ A @ A4 @ As ) @ B4 ) )
       => ( P @ A0 @ A1 ) ) ) ).

% revg.induct
thf(fact_92_zipf_Oinduct,axiom,
    ! [A: $tType,C2: $tType,B: $tType,P: ( A > B > C2 ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B > C2,A1: list @ A,A22: list @ B] :
      ( ! [F3: A > B > C2] : ( P @ F3 @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [F3: A > B > C2,A4: A,As: list @ A,B4: B,Bs: list @ B] :
            ( ( P @ F3 @ As @ Bs )
           => ( P @ F3 @ ( cons @ A @ A4 @ As ) @ ( cons @ B @ B4 @ Bs ) ) )
       => ( ! [A4: A > B > C2,V: A,Va: list @ A] : ( P @ A4 @ ( cons @ A @ V @ Va ) @ ( nil @ B ) )
         => ( ! [A4: A > B > C2,V: B,Va: list @ B] : ( P @ A4 @ ( nil @ A ) @ ( cons @ B @ V @ Va ) )
           => ( P @ A0 @ A1 @ A22 ) ) ) ) ) ).

% zipf.induct
thf(fact_93_list__2pre__induct,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,W1: list @ A,W2: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [E2: A,W12: list @ A,W22: list @ B] :
            ( ( P @ W12 @ W22 )
           => ( P @ ( cons @ A @ E2 @ W12 ) @ W22 ) )
       => ( ! [E2: B,W13: list @ A,W23: list @ B] :
              ( ( P @ W13 @ W23 )
             => ( P @ W13 @ ( cons @ B @ E2 @ W23 ) ) )
         => ( P @ W1 @ W2 ) ) ) ) ).

% list_2pre_induct
thf(fact_94_list__induct__first2,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X2: A] : ( P @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [X1: A,X23: A,Xs2: list @ A] :
              ( ( P @ Xs2 )
             => ( P @ ( cons @ A @ X1 @ ( cons @ A @ X23 @ Xs2 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_induct_first2
thf(fact_95_list__all__zip_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: ( A > B > $o ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B > $o,A1: list @ A,A22: list @ B] :
      ( ! [P2: A > B > $o] : ( P @ P2 @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [P2: A > B > $o,A4: A,As: list @ A,B4: B,Bs: list @ B] :
            ( ( P @ P2 @ As @ Bs )
           => ( P @ P2 @ ( cons @ A @ A4 @ As ) @ ( cons @ B @ B4 @ Bs ) ) )
       => ( ! [P2: A > B > $o,V: A,Va: list @ A] : ( P @ P2 @ ( cons @ A @ V @ Va ) @ ( nil @ B ) )
         => ( ! [P2: A > B > $o,V: B,Va: list @ B] : ( P @ P2 @ ( nil @ A ) @ ( cons @ B @ V @ Va ) )
           => ( P @ A0 @ A1 @ A22 ) ) ) ) ) ).

% list_all_zip.induct
thf(fact_96_mergesort__by__rel__merge_Oinduct,axiom,
    ! [A: $tType,P: ( A > A > $o ) > ( list @ A ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A,A22: list @ A] :
      ( ! [R: A > A > $o,X2: A,Xs2: list @ A,Y4: A,Ys2: list @ A] :
          ( ( ( R @ X2 @ Y4 )
           => ( P @ R @ Xs2 @ ( cons @ A @ Y4 @ Ys2 ) ) )
         => ( ( ~ ( R @ X2 @ Y4 )
             => ( P @ R @ ( cons @ A @ X2 @ Xs2 ) @ Ys2 ) )
           => ( P @ R @ ( cons @ A @ X2 @ Xs2 ) @ ( cons @ A @ Y4 @ Ys2 ) ) ) )
     => ( ! [R: A > A > $o,Xs2: list @ A] : ( P @ R @ Xs2 @ ( nil @ A ) )
       => ( ! [R: A > A > $o,V: A,Va: list @ A] : ( P @ R @ ( nil @ A ) @ ( cons @ A @ V @ Va ) )
         => ( P @ A0 @ A1 @ A22 ) ) ) ) ).

% mergesort_by_rel_merge.induct
thf(fact_97_mergesort__by__rel__merge__induct,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,R2: A > B > $o,Xs: list @ A,Ys: list @ B] :
      ( ! [Xs2: list @ A] : ( P @ Xs2 @ ( nil @ B ) )
     => ( ! [X1: list @ B] : ( P @ ( nil @ A ) @ X1 )
       => ( ! [X2: A,Xs2: list @ A,Y4: B,Ys2: list @ B] :
              ( ( R2 @ X2 @ Y4 )
             => ( ( P @ Xs2 @ ( cons @ B @ Y4 @ Ys2 ) )
               => ( P @ ( cons @ A @ X2 @ Xs2 ) @ ( cons @ B @ Y4 @ Ys2 ) ) ) )
         => ( ! [X2: A,Xs2: list @ A,Y4: B,Ys2: list @ B] :
                ( ~ ( R2 @ X2 @ Y4 )
               => ( ( P @ ( cons @ A @ X2 @ Xs2 ) @ Ys2 )
                 => ( P @ ( cons @ A @ X2 @ Xs2 ) @ ( cons @ B @ Y4 @ Ys2 ) ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% mergesort_by_rel_merge_induct
thf(fact_98_list_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( nil @ A )
     != ( cons @ A @ X21 @ X22 ) ) ).

% list.distinct(1)
thf(fact_99_list_OdiscI,axiom,
    ! [A: $tType,List: list @ A,X21: A,X22: list @ A] :
      ( ( List
        = ( cons @ A @ X21 @ X22 ) )
     => ( List
       != ( nil @ A ) ) ) ).

% list.discI
thf(fact_100_list_Oexhaust,axiom,
    ! [A: $tType,Y: list @ A] :
      ( ( Y
       != ( nil @ A ) )
     => ~ ! [X212: A,X222: list @ A] :
            ( Y
           != ( cons @ A @ X212 @ X222 ) ) ) ).

% list.exhaust
thf(fact_101_list_Oinducts,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,List: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X1: A,X23: list @ A] :
            ( ( P @ X23 )
           => ( P @ ( cons @ A @ X1 @ X23 ) ) )
       => ( P @ List ) ) ) ).

% list.inducts
thf(fact_102_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
      = ( ? [Y3: A,Ys3: list @ A] :
            ( Xs
            = ( cons @ A @ Y3 @ Ys3 ) ) ) ) ).

% neq_Nil_conv
thf(fact_103_list__induct2_H,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X2: A,Xs2: list @ A] : ( P @ ( cons @ A @ X2 @ Xs2 ) @ ( nil @ B ) )
       => ( ! [Y4: B,Ys2: list @ B] : ( P @ ( nil @ A ) @ ( cons @ B @ Y4 @ Ys2 ) )
         => ( ! [X2: A,Xs2: list @ A,Y4: B,Ys2: list @ B] :
                ( ( P @ Xs2 @ Ys2 )
               => ( P @ ( cons @ A @ X2 @ Xs2 ) @ ( cons @ B @ Y4 @ Ys2 ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% list_induct2'
thf(fact_104_splice_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
     => ( ! [V: A,Va: list @ A] : ( P @ ( cons @ A @ V @ Va ) @ ( nil @ A ) )
       => ( ! [X2: A,Xs2: list @ A,Y4: A,Ys2: list @ A] :
              ( ( P @ Xs2 @ Ys2 )
             => ( P @ ( cons @ A @ X2 @ Xs2 ) @ ( cons @ A @ Y4 @ Ys2 ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% splice.induct
thf(fact_105_remdups__adj_Ocases,axiom,
    ! [A: $tType,X: list @ A] :
      ( ( X
       != ( nil @ A ) )
     => ( ! [X2: A] :
            ( X
           != ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ~ ! [X2: A,Y4: A,Xs2: list @ A] :
              ( X
             != ( cons @ A @ X2 @ ( cons @ A @ Y4 @ Xs2 ) ) ) ) ) ).

% remdups_adj.cases
thf(fact_106_remdups__adj_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,A0: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X2: A] : ( P @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [X2: A,Y4: A,Xs2: list @ A] :
              ( ( ( X2 = Y4 )
               => ( P @ ( cons @ A @ X2 @ Xs2 ) ) )
             => ( ( ( X2 != Y4 )
                 => ( P @ ( cons @ A @ Y4 @ Xs2 ) ) )
               => ( P @ ( cons @ A @ X2 @ ( cons @ A @ Y4 @ Xs2 ) ) ) ) )
         => ( P @ A0 ) ) ) ) ).

% remdups_adj.induct
thf(fact_107_list__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X2: A] : ( P @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [X2: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( cons @ A @ X2 @ Xs2 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_nonempty_induct
thf(fact_108_map__tailrec__rev_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: ( A > B ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B,A1: list @ A,A22: list @ B] :
      ( ! [F3: A > B,X1: list @ B] : ( P @ F3 @ ( nil @ A ) @ X1 )
     => ( ! [F3: A > B,A4: A,As: list @ A,Bs: list @ B] :
            ( ( P @ F3 @ As @ ( cons @ B @ ( F3 @ A4 ) @ Bs ) )
           => ( P @ F3 @ ( cons @ A @ A4 @ As ) @ Bs ) )
       => ( P @ A0 @ A1 @ A22 ) ) ) ).

% map_tailrec_rev.induct
thf(fact_109_subset__code_I3_J,axiom,
    ! [C2: $tType] :
      ~ ( ord_less_eq @ ( set @ C2 ) @ ( coset @ C2 @ ( nil @ C2 ) ) @ ( set2 @ C2 @ ( nil @ C2 ) ) ) ).

% subset_code(3)
thf(fact_110_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : ( distinct @ A @ ( nil @ A ) ) ).

% distinct.simps(1)
thf(fact_111_sorted_ONil,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( linorder_sorted @ A @ ( nil @ A ) ) ) ).

% sorted.Nil
thf(fact_112_subset__sorted_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L2: list @ A] : ( sorted1061247458sorted @ A @ ( nil @ A ) @ L2 ) ) ).

% subset_sorted.simps(1)
thf(fact_113_distinct__singleton,axiom,
    ! [A: $tType,X: A] : ( distinct @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) ).

% distinct_singleton
thf(fact_114_subset__sorted_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X12: A,L1: list @ A] :
          ~ ( sorted1061247458sorted @ A @ ( cons @ A @ X12 @ L1 ) @ ( nil @ A ) ) ) ).

% subset_sorted.simps(2)
thf(fact_115_ord__eq__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A,D: A] :
          ( ( A3 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ( C = D )
             => ( ord_less_eq @ A @ A3 @ D ) ) ) ) ) ).

% ord_eq_le_eq_trans
thf(fact_116_member__rec_I1_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Y: A] :
      ( ( member @ A @ ( cons @ A @ X @ Xs ) @ Y )
      = ( ( X = Y )
        | ( member @ A @ Xs @ Y ) ) ) ).

% member_rec(1)
thf(fact_117_list__tail__coinc,axiom,
    ! [A: $tType,N1: A,R1: list @ A,N2: A,R22: list @ A] :
      ( ( ( cons @ A @ N1 @ R1 )
        = ( cons @ A @ N2 @ R22 ) )
     => ( ( N1 = N2 )
        & ( R1 = R22 ) ) ) ).

% list_tail_coinc
thf(fact_118_the__elem__set,axiom,
    ! [A: $tType,X: A] :
      ( ( the_elem @ A @ ( set2 @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) )
      = X ) ).

% the_elem_set
thf(fact_119_quicksort_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: list @ A] :
          ( ( X
           != ( nil @ A ) )
         => ~ ! [X2: A,Xs2: list @ A] :
                ( X
               != ( cons @ A @ X2 @ Xs2 ) ) ) ) ).

% quicksort.cases
thf(fact_120_remove__code_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( remove @ A @ X @ ( coset @ A @ Xs ) )
      = ( coset @ A @ ( insert @ A @ X @ Xs ) ) ) ).

% remove_code(2)
thf(fact_121_sorted__append__bigger,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Y: A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ! [X2: A] :
                ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ X2 @ Y ) )
           => ( linorder_sorted @ A @ ( append @ A @ Xs @ ( cons @ A @ Y @ ( nil @ A ) ) ) ) ) ) ) ).

% sorted_append_bigger
thf(fact_122_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: A > $o] :
      ~ ( list_ex1 @ A @ P @ ( nil @ A ) ) ).

% list_ex1_simps(1)
thf(fact_123_sorted__hd__min,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A] :
          ( ( Xs
           != ( nil @ A ) )
         => ( ( linorder_sorted @ A @ Xs )
           => ! [X4: A] :
                ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ ( hd @ A @ Xs ) @ X4 ) ) ) ) ) ).

% sorted_hd_min
thf(fact_124_same__append__eq,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( append @ A @ Xs @ Zs ) )
      = ( Ys = Zs ) ) ).

% same_append_eq
thf(fact_125_append__same__eq,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A,Zs: list @ A] :
      ( ( ( append @ A @ Ys @ Xs )
        = ( append @ A @ Zs @ Xs ) )
      = ( Ys = Zs ) ) ).

% append_same_eq
thf(fact_126_append__assoc,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( append @ A @ ( append @ A @ Xs @ Ys ) @ Zs )
      = ( append @ A @ Xs @ ( append @ A @ Ys @ Zs ) ) ) ).

% append_assoc
thf(fact_127_member__remove,axiom,
    ! [A: $tType,X: A,Y: A,A2: set @ A] :
      ( ( member2 @ A @ X @ ( remove @ A @ Y @ A2 ) )
      = ( ( member2 @ A @ X @ A2 )
        & ( X != Y ) ) ) ).

% member_remove
thf(fact_128_append__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( nil @ A ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys
          = ( nil @ A ) ) ) ) ).

% append_is_Nil_conv
thf(fact_129_Nil__is__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( nil @ A )
        = ( append @ A @ Xs @ Ys ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys
          = ( nil @ A ) ) ) ) ).

% Nil_is_append_conv
thf(fact_130_self__append__conv2,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A] :
      ( ( Ys
        = ( append @ A @ Xs @ Ys ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% self_append_conv2
thf(fact_131_append__self__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = Ys )
      = ( Xs
        = ( nil @ A ) ) ) ).

% append_self_conv2
thf(fact_132_self__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs
        = ( append @ A @ Xs @ Ys ) )
      = ( Ys
        = ( nil @ A ) ) ) ).

% self_append_conv
thf(fact_133_append__self__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = Xs )
      = ( Ys
        = ( nil @ A ) ) ) ).

% append_self_conv
thf(fact_134_append__Nil2,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( append @ A @ Xs @ ( nil @ A ) )
      = Xs ) ).

% append_Nil2
thf(fact_135_append1__eq__conv,axiom,
    ! [A: $tType,Xs: list @ A,X: A,Ys: list @ A,Y: A] :
      ( ( ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) )
        = ( append @ A @ Ys @ ( cons @ A @ Y @ ( nil @ A ) ) ) )
      = ( ( Xs = Ys )
        & ( X = Y ) ) ) ).

% append1_eq_conv
thf(fact_136_list__ee__eq__leel_I1_J,axiom,
    ! [A: $tType,E1: A,E22: A,L1: list @ A,E12: A,E23: A,L2: list @ A] :
      ( ( ( cons @ A @ E1 @ ( cons @ A @ E22 @ ( nil @ A ) ) )
        = ( append @ A @ L1 @ ( cons @ A @ E12 @ ( cons @ A @ E23 @ L2 ) ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E1 = E12 )
        & ( E22 = E23 )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_ee_eq_leel(1)
thf(fact_137_list__ee__eq__leel_I2_J,axiom,
    ! [A: $tType,L1: list @ A,E12: A,E23: A,L2: list @ A,E1: A,E22: A] :
      ( ( ( append @ A @ L1 @ ( cons @ A @ E12 @ ( cons @ A @ E23 @ L2 ) ) )
        = ( cons @ A @ E1 @ ( cons @ A @ E22 @ ( nil @ A ) ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E1 = E12 )
        & ( E22 = E23 )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_ee_eq_leel(2)
thf(fact_138_list__se__match_I1_J,axiom,
    ! [A: $tType,L1: list @ A,L2: list @ A,A3: A] :
      ( ( L1
       != ( nil @ A ) )
     => ( ( ( append @ A @ L1 @ L2 )
          = ( cons @ A @ A3 @ ( nil @ A ) ) )
        = ( ( L1
            = ( cons @ A @ A3 @ ( nil @ A ) ) )
          & ( L2
            = ( nil @ A ) ) ) ) ) ).

% list_se_match(1)
thf(fact_139_list__se__match_I2_J,axiom,
    ! [A: $tType,L2: list @ A,L1: list @ A,A3: A] :
      ( ( L2
       != ( nil @ A ) )
     => ( ( ( append @ A @ L1 @ L2 )
          = ( cons @ A @ A3 @ ( nil @ A ) ) )
        = ( ( L1
            = ( nil @ A ) )
          & ( L2
            = ( cons @ A @ A3 @ ( nil @ A ) ) ) ) ) ) ).

% list_se_match(2)
thf(fact_140_list__se__match_I3_J,axiom,
    ! [A: $tType,L1: list @ A,A3: A,L2: list @ A] :
      ( ( L1
       != ( nil @ A ) )
     => ( ( ( cons @ A @ A3 @ ( nil @ A ) )
          = ( append @ A @ L1 @ L2 ) )
        = ( ( L1
            = ( cons @ A @ A3 @ ( nil @ A ) ) )
          & ( L2
            = ( nil @ A ) ) ) ) ) ).

% list_se_match(3)
thf(fact_141_list__se__match_I4_J,axiom,
    ! [A: $tType,L2: list @ A,A3: A,L1: list @ A] :
      ( ( L2
       != ( nil @ A ) )
     => ( ( ( cons @ A @ A3 @ ( nil @ A ) )
          = ( append @ A @ L1 @ L2 ) )
        = ( ( L1
            = ( nil @ A ) )
          & ( L2
            = ( cons @ A @ A3 @ ( nil @ A ) ) ) ) ) ) ).

% list_se_match(4)
thf(fact_142_list__e__eq__lel_I1_J,axiom,
    ! [A: $tType,E: A,L1: list @ A,E3: A,L2: list @ A] :
      ( ( ( cons @ A @ E @ ( nil @ A ) )
        = ( append @ A @ L1 @ ( cons @ A @ E3 @ L2 ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E3 = E )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_e_eq_lel(1)
thf(fact_143_list__e__eq__lel_I2_J,axiom,
    ! [A: $tType,L1: list @ A,E3: A,L2: list @ A,E: A] :
      ( ( ( append @ A @ L1 @ ( cons @ A @ E3 @ L2 ) )
        = ( cons @ A @ E @ ( nil @ A ) ) )
      = ( ( L1
          = ( nil @ A ) )
        & ( E3 = E )
        & ( L2
          = ( nil @ A ) ) ) ) ).

% list_e_eq_lel(2)
thf(fact_144_hd__append2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( hd @ A @ ( append @ A @ Xs @ Ys ) )
        = ( hd @ A @ Xs ) ) ) ).

% hd_append2
thf(fact_145_hd__append,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( hd @ A @ ( append @ A @ Xs @ Ys ) )
          = ( hd @ A @ Ys ) ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( hd @ A @ ( append @ A @ Xs @ Ys ) )
          = ( hd @ A @ Xs ) ) ) ) ).

% hd_append
thf(fact_146_longest__common__prefix,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
    ? [Ps: list @ A,Xs4: list @ A,Ys4: list @ A] :
      ( ( Xs
        = ( append @ A @ Ps @ Xs4 ) )
      & ( Ys
        = ( append @ A @ Ps @ Ys4 ) )
      & ( ( Xs4
          = ( nil @ A ) )
        | ( Ys4
          = ( nil @ A ) )
        | ( ( hd @ A @ Xs4 )
         != ( hd @ A @ Ys4 ) ) ) ) ).

% longest_common_prefix
thf(fact_147_append__eq__append__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,Zs: list @ A,Ts: list @ A] :
      ( ( ( append @ A @ Xs @ Ys )
        = ( append @ A @ Zs @ Ts ) )
      = ( ? [Us: list @ A] :
            ( ( ( Xs
                = ( append @ A @ Zs @ Us ) )
              & ( ( append @ A @ Us @ Ys )
                = Ts ) )
            | ( ( ( append @ A @ Xs @ Us )
                = Zs )
              & ( Ys
                = ( append @ A @ Us @ Ts ) ) ) ) ) ) ).

% append_eq_append_conv2
thf(fact_148_append__eq__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Xs1: list @ A,Zs: list @ A,Ys: list @ A,Us2: list @ A] :
      ( ( ( append @ A @ Xs @ Xs1 )
        = Zs )
     => ( ( Ys
          = ( append @ A @ Xs1 @ Us2 ) )
       => ( ( append @ A @ Xs @ Ys )
          = ( append @ A @ Zs @ Us2 ) ) ) ) ).

% append_eq_appendI
thf(fact_149_append__Cons,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A] :
      ( ( append @ A @ ( cons @ A @ X @ Xs ) @ Ys )
      = ( cons @ A @ X @ ( append @ A @ Xs @ Ys ) ) ) ).

% append_Cons
thf(fact_150_Cons__eq__appendI,axiom,
    ! [A: $tType,X: A,Xs1: list @ A,Ys: list @ A,Xs: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs1 )
        = Ys )
     => ( ( Xs
          = ( append @ A @ Xs1 @ Zs ) )
       => ( ( cons @ A @ X @ Xs )
          = ( append @ A @ Ys @ Zs ) ) ) ) ).

% Cons_eq_appendI
thf(fact_151_list__match__lel__lel,axiom,
    ! [A: $tType,C1: list @ A,Qs: A,C22: list @ A,C12: list @ A,Qs2: A,C23: list @ A] :
      ( ( ( append @ A @ C1 @ ( cons @ A @ Qs @ C22 ) )
        = ( append @ A @ C12 @ ( cons @ A @ Qs2 @ C23 ) ) )
     => ( ! [C21: list @ A] :
            ( ( C1
              = ( append @ A @ C12 @ ( cons @ A @ Qs2 @ C21 ) ) )
           => ( C23
             != ( append @ A @ C21 @ ( cons @ A @ Qs @ C22 ) ) ) )
       => ( ( ( C12 = C1 )
           => ( ( Qs2 = Qs )
             => ( C23 != C22 ) ) )
         => ~ ! [C212: list @ A] :
                ( ( C12
                  = ( append @ A @ C1 @ ( cons @ A @ Qs @ C212 ) ) )
               => ( C22
                 != ( append @ A @ C212 @ ( cons @ A @ Qs2 @ C23 ) ) ) ) ) ) ) ).

% list_match_lel_lel
thf(fact_152_append__Nil,axiom,
    ! [A: $tType,Ys: list @ A] :
      ( ( append @ A @ ( nil @ A ) @ Ys )
      = Ys ) ).

% append_Nil
thf(fact_153_eq__Nil__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs = Ys )
     => ( Xs
        = ( append @ A @ ( nil @ A ) @ Ys ) ) ) ).

% eq_Nil_appendI
thf(fact_154_list_Osel_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( hd @ A @ ( cons @ A @ X21 @ X22 ) )
      = X21 ) ).

% list.sel(1)
thf(fact_155_rev__induct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X2: A,Xs2: list @ A] :
            ( ( P @ Xs2 )
           => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X2 @ ( nil @ A ) ) ) ) )
       => ( P @ Xs ) ) ) ).

% rev_induct
thf(fact_156_rev__exhaust,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ~ ! [Ys2: list @ A,Y4: A] :
            ( Xs
           != ( append @ A @ Ys2 @ ( cons @ A @ Y4 @ ( nil @ A ) ) ) ) ) ).

% rev_exhaust
thf(fact_157_Cons__eq__append__conv,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs )
        = ( append @ A @ Ys @ Zs ) )
      = ( ( ( Ys
            = ( nil @ A ) )
          & ( ( cons @ A @ X @ Xs )
            = Zs ) )
        | ? [Ys5: list @ A] :
            ( ( ( cons @ A @ X @ Ys5 )
              = Ys )
            & ( Xs
              = ( append @ A @ Ys5 @ Zs ) ) ) ) ) ).

% Cons_eq_append_conv
thf(fact_158_append__eq__Cons__conv,axiom,
    ! [A: $tType,Ys: list @ A,Zs: list @ A,X: A,Xs: list @ A] :
      ( ( ( append @ A @ Ys @ Zs )
        = ( cons @ A @ X @ Xs ) )
      = ( ( ( Ys
            = ( nil @ A ) )
          & ( Zs
            = ( cons @ A @ X @ Xs ) ) )
        | ? [Ys5: list @ A] :
            ( ( Ys
              = ( cons @ A @ X @ Ys5 ) )
            & ( ( append @ A @ Ys5 @ Zs )
              = Xs ) ) ) ) ).

% append_eq_Cons_conv
thf(fact_159_rev__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X2: A] : ( P @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [X2: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X2 @ ( nil @ A ) ) ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% rev_nonempty_induct
thf(fact_160_list__append__eq__Cons__cases,axiom,
    ! [A: $tType,Ys: list @ A,Zs: list @ A,X: A,Xs: list @ A] :
      ( ( ( append @ A @ Ys @ Zs )
        = ( cons @ A @ X @ Xs ) )
     => ( ( ( Ys
            = ( nil @ A ) )
         => ( Zs
           != ( cons @ A @ X @ Xs ) ) )
       => ~ ! [Ys4: list @ A] :
              ( ( Ys
                = ( cons @ A @ X @ Ys4 ) )
             => ( ( append @ A @ Ys4 @ Zs )
               != Xs ) ) ) ) ).

% list_append_eq_Cons_cases
thf(fact_161_list__Cons__eq__append__cases,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A,Zs: list @ A] :
      ( ( ( cons @ A @ X @ Xs )
        = ( append @ A @ Ys @ Zs ) )
     => ( ( ( Ys
            = ( nil @ A ) )
         => ( Zs
           != ( cons @ A @ X @ Xs ) ) )
       => ~ ! [Ys4: list @ A] :
              ( ( Ys
                = ( cons @ A @ X @ Ys4 ) )
             => ( ( append @ A @ Ys4 @ Zs )
               != Xs ) ) ) ) ).

% list_Cons_eq_append_cases
thf(fact_162_rev__nonempty__induct2_H,axiom,
    ! [A: $tType,B: $tType,Xs: list @ A,Ys: list @ B,P: ( list @ A ) > ( list @ B ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( Ys
         != ( nil @ B ) )
       => ( ! [X2: A,Y4: B] : ( P @ ( cons @ A @ X2 @ ( nil @ A ) ) @ ( cons @ B @ Y4 @ ( nil @ B ) ) )
         => ( ! [X2: A,Xs2: list @ A,Y4: B] :
                ( ( Xs2
                 != ( nil @ A ) )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X2 @ ( nil @ A ) ) ) @ ( cons @ B @ Y4 @ ( nil @ B ) ) ) )
           => ( ! [X2: A,Y4: B,Ys2: list @ B] :
                  ( ( Ys2
                   != ( nil @ B ) )
                 => ( P @ ( cons @ A @ X2 @ ( nil @ A ) ) @ ( append @ B @ Ys2 @ ( cons @ B @ Y4 @ ( nil @ B ) ) ) ) )
             => ( ! [X2: A,Xs2: list @ A,Y4: B,Ys2: list @ B] :
                    ( ( P @ Xs2 @ Ys2 )
                   => ( ( Xs2
                       != ( nil @ A ) )
                     => ( ( Ys2
                         != ( nil @ B ) )
                       => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X2 @ ( nil @ A ) ) ) @ ( append @ B @ Ys2 @ ( cons @ B @ Y4 @ ( nil @ B ) ) ) ) ) ) )
               => ( P @ Xs @ Ys ) ) ) ) ) ) ) ).

% rev_nonempty_induct2'
thf(fact_163_neq__Nil__rev__conv,axiom,
    ! [A: $tType,L: list @ A] :
      ( ( L
       != ( nil @ A ) )
      = ( ? [Xs3: list @ A,X3: A] :
            ( L
            = ( append @ A @ Xs3 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ) ) ).

% neq_Nil_rev_conv
thf(fact_164_list__rev__decomp,axiom,
    ! [A: $tType,L: list @ A] :
      ( ( L
       != ( nil @ A ) )
     => ? [Ll: list @ A,E2: A] :
          ( L
          = ( append @ A @ Ll @ ( cons @ A @ E2 @ ( nil @ A ) ) ) ) ) ).

% list_rev_decomp
thf(fact_165_rev__induct2_H,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X2: A,Xs2: list @ A] : ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X2 @ ( nil @ A ) ) ) @ ( nil @ B ) )
       => ( ! [Y4: B,Ys2: list @ B] : ( P @ ( nil @ A ) @ ( append @ B @ Ys2 @ ( cons @ B @ Y4 @ ( nil @ B ) ) ) )
         => ( ! [X2: A,Xs2: list @ A,Y4: B,Ys2: list @ B] :
                ( ( P @ Xs2 @ Ys2 )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X2 @ ( nil @ A ) ) ) @ ( append @ B @ Ys2 @ ( cons @ B @ Y4 @ ( nil @ B ) ) ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% rev_induct2'
thf(fact_166_split__list__first__prop__iff,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ( ? [X3: A] :
            ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
            & ( P @ X3 ) ) )
      = ( ? [Ys3: list @ A,X3: A] :
            ( ? [Zs2: list @ A] :
                ( Xs
                = ( append @ A @ Ys3 @ ( cons @ A @ X3 @ Zs2 ) ) )
            & ( P @ X3 )
            & ! [Y3: A] :
                ( ( member2 @ A @ Y3 @ ( set2 @ A @ Ys3 ) )
               => ~ ( P @ Y3 ) ) ) ) ) ).

% split_list_first_prop_iff
thf(fact_167_split__list__last__prop__iff,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ( ? [X3: A] :
            ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
            & ( P @ X3 ) ) )
      = ( ? [Ys3: list @ A,X3: A,Zs2: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X3 @ Zs2 ) ) )
            & ( P @ X3 )
            & ! [Y3: A] :
                ( ( member2 @ A @ Y3 @ ( set2 @ A @ Zs2 ) )
               => ~ ( P @ Y3 ) ) ) ) ) ).

% split_list_last_prop_iff
thf(fact_168_in__set__conv__decomp__first,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs2: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X @ Zs2 ) ) )
            & ~ ( member2 @ A @ X @ ( set2 @ A @ Ys3 ) ) ) ) ) ).

% in_set_conv_decomp_first
thf(fact_169_in__set__conv__decomp__last,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs2: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys3 @ ( cons @ A @ X @ Zs2 ) ) )
            & ~ ( member2 @ A @ X @ ( set2 @ A @ Zs2 ) ) ) ) ) ).

% in_set_conv_decomp_last
thf(fact_170_split__list__first__propE,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ~ ! [Ys2: list @ A,X2: A] :
            ( ? [Zs3: list @ A] :
                ( Xs
                = ( append @ A @ Ys2 @ ( cons @ A @ X2 @ Zs3 ) ) )
           => ( ( P @ X2 )
             => ~ ! [Xa: A] :
                    ( ( member2 @ A @ Xa @ ( set2 @ A @ Ys2 ) )
                   => ~ ( P @ Xa ) ) ) ) ) ).

% split_list_first_propE
thf(fact_171_split__list__last__propE,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ~ ! [Ys2: list @ A,X2: A,Zs3: list @ A] :
            ( ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X2 @ Zs3 ) ) )
           => ( ( P @ X2 )
             => ~ ! [Xa: A] :
                    ( ( member2 @ A @ Xa @ ( set2 @ A @ Zs3 ) )
                   => ~ ( P @ Xa ) ) ) ) ) ).

% split_list_last_propE
thf(fact_172_split__list__first__prop,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ? [Ys2: list @ A,X2: A] :
          ( ? [Zs3: list @ A] :
              ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X2 @ Zs3 ) ) )
          & ( P @ X2 )
          & ! [Xa: A] :
              ( ( member2 @ A @ Xa @ ( set2 @ A @ Ys2 ) )
             => ~ ( P @ Xa ) ) ) ) ).

% split_list_first_prop
thf(fact_173_split__list__last__prop,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ? [Ys2: list @ A,X2: A,Zs3: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X2 @ Zs3 ) ) )
          & ( P @ X2 )
          & ! [Xa: A] :
              ( ( member2 @ A @ Xa @ ( set2 @ A @ Zs3 ) )
             => ~ ( P @ Xa ) ) ) ) ).

% split_list_last_prop
thf(fact_174_in__set__conv__decomp,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
      = ( ? [Ys3: list @ A,Zs2: list @ A] :
            ( Xs
            = ( append @ A @ Ys3 @ ( cons @ A @ X @ Zs2 ) ) ) ) ) ).

% in_set_conv_decomp
thf(fact_175_split__list__propE,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ~ ! [Ys2: list @ A,X2: A] :
            ( ? [Zs3: list @ A] :
                ( Xs
                = ( append @ A @ Ys2 @ ( cons @ A @ X2 @ Zs3 ) ) )
           => ~ ( P @ X2 ) ) ) ).

% split_list_propE
thf(fact_176_split__list__first,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs3: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs3 ) ) )
          & ~ ( member2 @ A @ X @ ( set2 @ A @ Ys2 ) ) ) ) ).

% split_list_first
thf(fact_177_split__list__prop,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ? [X4: A] :
          ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
          & ( P @ X4 ) )
     => ? [Ys2: list @ A,X2: A] :
          ( ? [Zs3: list @ A] :
              ( Xs
              = ( append @ A @ Ys2 @ ( cons @ A @ X2 @ Zs3 ) ) )
          & ( P @ X2 ) ) ) ).

% split_list_prop
thf(fact_178_split__list__last,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs3: list @ A] :
          ( ( Xs
            = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs3 ) ) )
          & ~ ( member2 @ A @ X @ ( set2 @ A @ Zs3 ) ) ) ) ).

% split_list_last
thf(fact_179_split__list,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
     => ? [Ys2: list @ A,Zs3: list @ A] :
          ( Xs
          = ( append @ A @ Ys2 @ ( cons @ A @ X @ Zs3 ) ) ) ) ).

% split_list
thf(fact_180_in__set__list__format,axiom,
    ! [A: $tType,E: A,L: list @ A] :
      ( ( member2 @ A @ E @ ( set2 @ A @ L ) )
     => ~ ! [L12: list @ A,L22: list @ A] :
            ( L
           != ( append @ A @ L12 @ ( cons @ A @ E @ L22 ) ) ) ) ).

% in_set_list_format
thf(fact_181_xy__in__set__cases,axiom,
    ! [A: $tType,X: A,L: list @ A,Y: A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ L ) )
     => ( ( member2 @ A @ Y @ ( set2 @ A @ L ) )
       => ( ( ( X = Y )
           => ! [L12: list @ A,L22: list @ A] :
                ( L
               != ( append @ A @ L12 @ ( cons @ A @ Y @ L22 ) ) ) )
         => ( ( ( X != Y )
             => ! [L12: list @ A,L22: list @ A,L3: list @ A] :
                  ( L
                 != ( append @ A @ L12 @ ( cons @ A @ X @ ( append @ A @ L22 @ ( cons @ A @ Y @ L3 ) ) ) ) ) )
           => ~ ( ( X != Y )
               => ! [L12: list @ A,L22: list @ A,L3: list @ A] :
                    ( L
                   != ( append @ A @ L12 @ ( cons @ A @ Y @ ( append @ A @ L22 @ ( cons @ A @ X @ L3 ) ) ) ) ) ) ) ) ) ) ).

% xy_in_set_cases
thf(fact_182_distinct__match,axiom,
    ! [A: $tType,Al: list @ A,E: A,Bl: list @ A,Al2: list @ A,Bl2: list @ A] :
      ( ( distinct @ A @ ( append @ A @ Al @ ( cons @ A @ E @ Bl ) ) )
     => ( ( ( append @ A @ Al @ ( cons @ A @ E @ Bl ) )
          = ( append @ A @ Al2 @ ( cons @ A @ E @ Bl2 ) ) )
        = ( ( Al = Al2 )
          & ( Bl = Bl2 ) ) ) ) ).

% distinct_match
thf(fact_183_list_Oset__sel_I1_J,axiom,
    ! [A: $tType,A3: list @ A] :
      ( ( A3
       != ( nil @ A ) )
     => ( member2 @ A @ ( hd @ A @ A3 ) @ ( set2 @ A @ A3 ) ) ) ).

% list.set_sel(1)
thf(fact_184_hd__in__set,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( member2 @ A @ ( hd @ A @ Xs ) @ ( set2 @ A @ Xs ) ) ) ).

% hd_in_set
thf(fact_185_list__ex1__iff,axiom,
    ! [A: $tType] :
      ( ( list_ex1 @ A )
      = ( ^ [P3: A > $o,Xs3: list @ A] :
          ? [X3: A] :
            ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs3 ) )
            & ( P3 @ X3 )
            & ! [Y3: A] :
                ( ( ( member2 @ A @ Y3 @ ( set2 @ A @ Xs3 ) )
                  & ( P3 @ Y3 ) )
               => ( Y3 = X3 ) ) ) ) ) ).

% list_ex1_iff
thf(fact_186_not__distinct__decomp,axiom,
    ! [A: $tType,Ws: list @ A] :
      ( ~ ( distinct @ A @ Ws )
     => ? [Xs2: list @ A,Ys2: list @ A,Zs3: list @ A,Y4: A] :
          ( Ws
          = ( append @ A @ Xs2 @ ( append @ A @ ( cons @ A @ Y4 @ ( nil @ A ) ) @ ( append @ A @ Ys2 @ ( append @ A @ ( cons @ A @ Y4 @ ( nil @ A ) ) @ Zs3 ) ) ) ) ) ) ).

% not_distinct_decomp
thf(fact_187_sorted__append,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Ys: list @ A] :
          ( ( linorder_sorted @ A @ ( append @ A @ Xs @ Ys ) )
          = ( ( linorder_sorted @ A @ Xs )
            & ( linorder_sorted @ A @ Ys )
            & ! [X3: A] :
                ( ( member2 @ A @ X3 @ ( set2 @ A @ Xs ) )
               => ! [Y3: A] :
                    ( ( member2 @ A @ Y3 @ ( set2 @ A @ Ys ) )
                   => ( ord_less_eq @ A @ X3 @ Y3 ) ) ) ) ) ) ).

% sorted_append
thf(fact_188_not__distinct__conv__prefix,axiom,
    ! [A: $tType,As2: list @ A] :
      ( ( ~ ( distinct @ A @ As2 ) )
      = ( ? [Xs3: list @ A,Y3: A,Ys3: list @ A] :
            ( ( member2 @ A @ Y3 @ ( set2 @ A @ Xs3 ) )
            & ( distinct @ A @ Xs3 )
            & ( As2
              = ( append @ A @ Xs3 @ ( cons @ A @ Y3 @ Ys3 ) ) ) ) ) ) ).

% not_distinct_conv_prefix
thf(fact_189_not__distinct__split__distinct,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ~ ( distinct @ A @ Xs )
     => ~ ! [Y4: A,Ys2: list @ A] :
            ( ( distinct @ A @ Ys2 )
           => ( ( member2 @ A @ Y4 @ ( set2 @ A @ Ys2 ) )
             => ! [Zs3: list @ A] :
                  ( Xs
                 != ( append @ A @ Ys2 @ ( append @ A @ ( cons @ A @ Y4 @ ( nil @ A ) ) @ Zs3 ) ) ) ) ) ) ).

% not_distinct_split_distinct
thf(fact_190_can__select__set__list__ex1,axiom,
    ! [A: $tType,P: A > $o,A2: list @ A] :
      ( ( can_select @ A @ P @ ( set2 @ A @ A2 ) )
      = ( list_ex1 @ A @ P @ A2 ) ) ).

% can_select_set_list_ex1
thf(fact_191_sublists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( sublists @ A @ ( nil @ A ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% sublists.simps(1)
thf(fact_192_bind__simps_I2_J,axiom,
    ! [A: $tType,B: $tType,X: B,Xs: list @ B,F: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( cons @ B @ X @ Xs ) @ F )
      = ( append @ A @ ( F @ X ) @ ( bind @ B @ A @ Xs @ F ) ) ) ).

% bind_simps(2)
thf(fact_193_product__lists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( product_lists @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% product_lists.simps(1)
thf(fact_194_bind__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( nil @ B ) @ F )
      = ( nil @ A ) ) ).

% bind_simps(1)
thf(fact_195_can__select__def,axiom,
    ! [A: $tType] :
      ( ( can_select @ A )
      = ( ^ [P3: A > $o,A5: set @ A] :
          ? [X3: A] :
            ( ( member2 @ A @ X3 @ A5 )
            & ( P3 @ X3 )
            & ! [Y3: A] :
                ( ( ( member2 @ A @ Y3 @ A5 )
                  & ( P3 @ Y3 ) )
               => ( Y3 = X3 ) ) ) ) ) ).

% can_select_def
thf(fact_196_distinct__product__lists,axiom,
    ! [A: $tType,Xss2: list @ ( list @ A )] :
      ( ! [X2: list @ A] :
          ( ( member2 @ ( list @ A ) @ X2 @ ( set2 @ ( list @ A ) @ Xss2 ) )
         => ( distinct @ A @ X2 ) )
     => ( distinct @ ( list @ A ) @ ( product_lists @ A @ Xss2 ) ) ) ).

% distinct_product_lists
thf(fact_197_list__bind__cong,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,Ys: list @ A,F: A > ( list @ B ),G2: A > ( list @ B )] :
      ( ( Xs = Ys )
     => ( ! [X2: A] :
            ( ( member2 @ A @ X2 @ ( set2 @ A @ Xs ) )
           => ( ( F @ X2 )
              = ( G2 @ X2 ) ) )
       => ( ( bind @ A @ B @ Xs @ F )
          = ( bind @ A @ B @ Ys @ G2 ) ) ) ) ).

% list_bind_cong
thf(fact_198_maps__simps_I1_J,axiom,
    ! [A: $tType,B: $tType,F: B > ( list @ A ),X: B,Xs: list @ B] :
      ( ( maps @ B @ A @ F @ ( cons @ B @ X @ Xs ) )
      = ( append @ A @ ( F @ X ) @ ( maps @ B @ A @ F @ Xs ) ) ) ).

% maps_simps(1)
thf(fact_199_combinatorial__product_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( list_c659805718roduct @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% combinatorial_product.simps(1)
thf(fact_200_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F: B > ( list @ A )] :
      ( ( maps @ B @ A @ F @ ( nil @ B ) )
      = ( nil @ A ) ) ).

% maps_simps(2)
thf(fact_201_rotate1_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( rotate1 @ A @ ( cons @ A @ X @ Xs ) )
      = ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) ) ) ).

% rotate1.simps(2)
thf(fact_202_hd__last__singletonI,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( ( hd @ A @ Xs )
          = ( last @ A @ Xs ) )
       => ( ( distinct @ A @ Xs )
         => ( Xs
            = ( cons @ A @ ( hd @ A @ Xs ) @ ( nil @ A ) ) ) ) ) ) ).

% hd_last_singletonI
thf(fact_203_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( rotate1 @ A @ Xs )
        = ( nil @ A ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% rotate1_is_Nil_conv
thf(fact_204_set__rotate1,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( set2 @ A @ ( rotate1 @ A @ Xs ) )
      = ( set2 @ A @ Xs ) ) ).

% set_rotate1
thf(fact_205_distinct1__rotate,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( distinct @ A @ ( rotate1 @ A @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct1_rotate
thf(fact_206_Misc_Olast__in__set,axiom,
    ! [A: $tType,L: list @ A] :
      ( ( L
       != ( nil @ A ) )
     => ( member2 @ A @ ( last @ A @ L ) @ ( set2 @ A @ L ) ) ) ).

% Misc.last_in_set
thf(fact_207_List_Olast__in__set,axiom,
    ! [A: $tType,As2: list @ A] :
      ( ( As2
       != ( nil @ A ) )
     => ( member2 @ A @ ( last @ A @ As2 ) @ ( set2 @ A @ As2 ) ) ) ).

% List.last_in_set
thf(fact_208_last__appendR,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A] :
      ( ( Ys
       != ( nil @ A ) )
     => ( ( last @ A @ ( append @ A @ Xs @ Ys ) )
        = ( last @ A @ Ys ) ) ) ).

% last_appendR
thf(fact_209_last__appendL,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A] :
      ( ( Ys
        = ( nil @ A ) )
     => ( ( last @ A @ ( append @ A @ Xs @ Ys ) )
        = ( last @ A @ Xs ) ) ) ).

% last_appendL
thf(fact_210_last__snoc,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( last @ A @ ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) ) )
      = X ) ).

% last_snoc
thf(fact_211_last__append,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A] :
      ( ( ( Ys
          = ( nil @ A ) )
       => ( ( last @ A @ ( append @ A @ Xs @ Ys ) )
          = ( last @ A @ Xs ) ) )
      & ( ( Ys
         != ( nil @ A ) )
       => ( ( last @ A @ ( append @ A @ Xs @ Ys ) )
          = ( last @ A @ Ys ) ) ) ) ).

% last_append
thf(fact_212_longest__common__suffix,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
    ? [Ss: list @ A,Xs4: list @ A,Ys4: list @ A] :
      ( ( Xs
        = ( append @ A @ Xs4 @ Ss ) )
      & ( Ys
        = ( append @ A @ Ys4 @ Ss ) )
      & ( ( Xs4
          = ( nil @ A ) )
        | ( Ys4
          = ( nil @ A ) )
        | ( ( last @ A @ Xs4 )
         != ( last @ A @ Ys4 ) ) ) ) ).

% longest_common_suffix
thf(fact_213_last_Osimps,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( last @ A @ ( cons @ A @ X @ Xs ) )
          = X ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( last @ A @ ( cons @ A @ X @ Xs ) )
          = ( last @ A @ Xs ) ) ) ) ).

% last.simps
thf(fact_214_last__ConsL,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( Xs
        = ( nil @ A ) )
     => ( ( last @ A @ ( cons @ A @ X @ Xs ) )
        = X ) ) ).

% last_ConsL
thf(fact_215_last__ConsR,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( last @ A @ ( cons @ A @ X @ Xs ) )
        = ( last @ A @ Xs ) ) ) ).

% last_ConsR
thf(fact_216_rotate1_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( rotate1 @ A @ ( nil @ A ) )
      = ( nil @ A ) ) ).

% rotate1.simps(1)
thf(fact_217_sorted__hd__last,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L: list @ A] :
          ( ( linorder_sorted @ A @ L )
         => ( ( L
             != ( nil @ A ) )
           => ( ord_less_eq @ A @ ( hd @ A @ L ) @ ( last @ A @ L ) ) ) ) ) ).

% sorted_hd_last
thf(fact_218_append__butlast__last__id,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( append @ A @ ( butlast @ A @ Xs ) @ ( cons @ A @ ( last @ A @ Xs ) @ ( nil @ A ) ) )
        = Xs ) ) ).

% append_butlast_last_id
thf(fact_219_rotate1__hd__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( rotate1 @ A @ Xs )
        = ( append @ A @ ( tl @ A @ Xs ) @ ( cons @ A @ ( hd @ A @ Xs ) @ ( nil @ A ) ) ) ) ) ).

% rotate1_hd_tl
thf(fact_220_tl__append2,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( tl @ A @ ( append @ A @ Xs @ Ys ) )
        = ( append @ A @ ( tl @ A @ Xs ) @ Ys ) ) ) ).

% tl_append2
thf(fact_221_butlast__snoc,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( butlast @ A @ ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) ) )
      = Xs ) ).

% butlast_snoc
thf(fact_222_list_Ocollapse,axiom,
    ! [A: $tType,List: list @ A] :
      ( ( List
       != ( nil @ A ) )
     => ( ( cons @ A @ ( hd @ A @ List ) @ ( tl @ A @ List ) )
        = List ) ) ).

% list.collapse
thf(fact_223_hd__Cons__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( cons @ A @ ( hd @ A @ Xs ) @ ( tl @ A @ Xs ) )
        = Xs ) ) ).

% hd_Cons_tl
thf(fact_224_in__hd__or__tl__conv,axiom,
    ! [A: $tType,L: list @ A,X: A] :
      ( ( L
       != ( nil @ A ) )
     => ( ( ( X
            = ( hd @ A @ L ) )
          | ( member2 @ A @ X @ ( set2 @ A @ ( tl @ A @ L ) ) ) )
        = ( member2 @ A @ X @ ( set2 @ A @ L ) ) ) ) ).

% in_hd_or_tl_conv
thf(fact_225_last__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( Xs
          = ( nil @ A ) )
        | ( ( tl @ A @ Xs )
         != ( nil @ A ) ) )
     => ( ( last @ A @ ( tl @ A @ Xs ) )
        = ( last @ A @ Xs ) ) ) ).

% last_tl
thf(fact_226_tl__last,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( tl @ A @ Xs )
       != ( nil @ A ) )
     => ( ( last @ A @ Xs )
        = ( last @ A @ ( tl @ A @ Xs ) ) ) ) ).

% tl_last
thf(fact_227_tl__obtain__elem,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( ( tl @ A @ Xs )
          = ( nil @ A ) )
       => ~ ! [E2: A] :
              ( Xs
             != ( cons @ A @ E2 @ ( nil @ A ) ) ) ) ) ).

% tl_obtain_elem
thf(fact_228_tl__Nil,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( tl @ A @ Xs )
        = ( nil @ A ) )
      = ( ( Xs
          = ( nil @ A ) )
        | ? [X3: A] :
            ( Xs
            = ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ) ).

% tl_Nil
thf(fact_229_Nil__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( nil @ A )
        = ( tl @ A @ Xs ) )
      = ( ( Xs
          = ( nil @ A ) )
        | ? [X3: A] :
            ( Xs
            = ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ) ).

% Nil_tl
thf(fact_230_list_Oexpand,axiom,
    ! [A: $tType,List: list @ A,List2: list @ A] :
      ( ( ( List
          = ( nil @ A ) )
        = ( List2
          = ( nil @ A ) ) )
     => ( ( ( List
           != ( nil @ A ) )
         => ( ( List2
             != ( nil @ A ) )
           => ( ( ( hd @ A @ List )
                = ( hd @ A @ List2 ) )
              & ( ( tl @ A @ List )
                = ( tl @ A @ List2 ) ) ) ) )
       => ( List = List2 ) ) ) ).

% list.expand
thf(fact_231_butlast_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( butlast @ A @ ( cons @ A @ X @ Xs ) )
          = ( nil @ A ) ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( butlast @ A @ ( cons @ A @ X @ Xs ) )
          = ( cons @ A @ X @ ( butlast @ A @ Xs ) ) ) ) ) ).

% butlast.simps(2)
thf(fact_232_butlast__append,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A] :
      ( ( ( Ys
          = ( nil @ A ) )
       => ( ( butlast @ A @ ( append @ A @ Xs @ Ys ) )
          = ( butlast @ A @ Xs ) ) )
      & ( ( Ys
         != ( nil @ A ) )
       => ( ( butlast @ A @ ( append @ A @ Xs @ Ys ) )
          = ( append @ A @ Xs @ ( butlast @ A @ Ys ) ) ) ) ) ).

% butlast_append
thf(fact_233_butlast__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( butlast @ A @ ( tl @ A @ Xs ) )
      = ( tl @ A @ ( butlast @ A @ Xs ) ) ) ).

% butlast_tl
thf(fact_234_butlast_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( butlast @ A @ ( nil @ A ) )
      = ( nil @ A ) ) ).

% butlast.simps(1)
thf(fact_235_sorted__tl,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( linorder_sorted @ A @ ( tl @ A @ Xs ) ) ) ) ).

% sorted_tl
thf(fact_236_list_Osel_I2_J,axiom,
    ! [A: $tType] :
      ( ( tl @ A @ ( nil @ A ) )
      = ( nil @ A ) ) ).

% list.sel(2)
thf(fact_237_list_Osel_I3_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( tl @ A @ ( cons @ A @ X21 @ X22 ) )
      = X22 ) ).

% list.sel(3)
thf(fact_238_sorted__butlast,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A] :
          ( ( Xs
           != ( nil @ A ) )
         => ( ( linorder_sorted @ A @ Xs )
           => ( linorder_sorted @ A @ ( butlast @ A @ Xs ) ) ) ) ) ).

% sorted_butlast
thf(fact_239_in__set__tlD,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ ( tl @ A @ Xs ) ) )
     => ( member2 @ A @ X @ ( set2 @ A @ Xs ) ) ) ).

% in_set_tlD
thf(fact_240_List_Odistinct__tl,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( distinct @ A @ Xs )
     => ( distinct @ A @ ( tl @ A @ Xs ) ) ) ).

% List.distinct_tl
thf(fact_241_in__set__butlastD,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member2 @ A @ X @ ( set2 @ A @ ( butlast @ A @ Xs ) ) )
     => ( member2 @ A @ X @ ( set2 @ A @ Xs ) ) ) ).

% in_set_butlastD
thf(fact_242_distinct__butlast,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( distinct @ A @ Xs )
     => ( distinct @ A @ ( butlast @ A @ Xs ) ) ) ).

% distinct_butlast
thf(fact_243_in__set__butlast__appendI,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys: list @ A] :
      ( ( ( member2 @ A @ X @ ( set2 @ A @ ( butlast @ A @ Xs ) ) )
        | ( member2 @ A @ X @ ( set2 @ A @ ( butlast @ A @ Ys ) ) ) )
     => ( member2 @ A @ X @ ( set2 @ A @ ( butlast @ A @ ( append @ A @ Xs @ Ys ) ) ) ) ) ).

% in_set_butlast_appendI
thf(fact_244_not__hd__in__tl,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( X
       != ( hd @ A @ Xs ) )
     => ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
       => ( member2 @ A @ X @ ( set2 @ A @ ( tl @ A @ Xs ) ) ) ) ) ).

% not_hd_in_tl
thf(fact_245_Misc_Odistinct__tl,axiom,
    ! [A: $tType,L: list @ A] :
      ( ( L
       != ( nil @ A ) )
     => ( ( distinct @ A @ L )
       => ( distinct @ A @ ( tl @ A @ L ) ) ) ) ).

% Misc.distinct_tl
thf(fact_246_list_Oset__sel_I2_J,axiom,
    ! [A: $tType,A3: list @ A,X: A] :
      ( ( A3
       != ( nil @ A ) )
     => ( ( member2 @ A @ X @ ( set2 @ A @ ( tl @ A @ A3 ) ) )
       => ( member2 @ A @ X @ ( set2 @ A @ A3 ) ) ) ) ).

% list.set_sel(2)
thf(fact_247_tl__subset,axiom,
    ! [A: $tType,Xs: list @ A,A2: set @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ A2 )
       => ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ ( tl @ A @ Xs ) ) @ A2 ) ) ) ).

% tl_subset
thf(fact_248_list_Oexhaust__sel,axiom,
    ! [A: $tType,List: list @ A] :
      ( ( List
       != ( nil @ A ) )
     => ( List
        = ( cons @ A @ ( hd @ A @ List ) @ ( tl @ A @ List ) ) ) ) ).

% list.exhaust_sel
thf(fact_249_distinct__hd__tl,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( distinct @ A @ Xs )
     => ( ( X
          = ( hd @ A @ Xs ) )
       => ~ ( member2 @ A @ X @ ( set2 @ A @ ( tl @ A @ Xs ) ) ) ) ) ).

% distinct_hd_tl
thf(fact_250_butlast__subset,axiom,
    ! [A: $tType,Xs: list @ A,A2: set @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ A2 )
       => ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ ( butlast @ A @ Xs ) ) @ A2 ) ) ) ).

% butlast_subset
thf(fact_251_butlast__eq__consE,axiom,
    ! [A: $tType,L: list @ A,X: A,Xs: list @ A] :
      ( ( ( butlast @ A @ L )
        = ( cons @ A @ X @ Xs ) )
     => ~ ! [Xl: A] :
            ( L
           != ( cons @ A @ X @ ( append @ A @ Xs @ ( cons @ A @ Xl @ ( nil @ A ) ) ) ) ) ) ).

% butlast_eq_consE
thf(fact_252_butlast__eq__cons__conv,axiom,
    ! [A: $tType,L: list @ A,X: A,Xs: list @ A] :
      ( ( ( butlast @ A @ L )
        = ( cons @ A @ X @ Xs ) )
      = ( ? [Xl2: A] :
            ( L
            = ( cons @ A @ X @ ( append @ A @ Xs @ ( cons @ A @ Xl2 @ ( nil @ A ) ) ) ) ) ) ) ).

% butlast_eq_cons_conv
thf(fact_253_snoc__eq__iff__butlast_H,axiom,
    ! [A: $tType,Ys: list @ A,Xs: list @ A,X: A] :
      ( ( Ys
        = ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) ) )
      = ( ( Ys
         != ( nil @ A ) )
        & ( ( butlast @ A @ Ys )
          = Xs )
        & ( ( last @ A @ Ys )
          = X ) ) ) ).

% snoc_eq_iff_butlast'
thf(fact_254_snoc__eq__iff__butlast,axiom,
    ! [A: $tType,Xs: list @ A,X: A,Ys: list @ A] :
      ( ( ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) )
        = Ys )
      = ( ( Ys
         != ( nil @ A ) )
        & ( ( butlast @ A @ Ys )
          = Xs )
        & ( ( last @ A @ Ys )
          = X ) ) ) ).

% snoc_eq_iff_butlast

%----Subclasses (4)
thf(subcl_Orderings_Olinorder___HOL_Otype,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( type @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oord,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ord @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( order @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Opreorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( preorder @ A @ ( type2 @ A ) ) ) ).

%----Type constructors (10)
thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( preorder @ A8 @ ( type2 @ A8 ) )
     => ( preorder @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order @ A8 @ ( type2 @ A8 ) )
     => ( order @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 @ ( type2 @ A8 ) )
     => ( ord @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_1,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_2,axiom,
    ! [A7: $tType] : ( order @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_3,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_4,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_5,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_6,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $false @ X @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $true @ X @ Y )
      = X ) ).

%----Free types (1)
thf(tfree_0,hypothesis,
    linorder @ a @ ( type2 @ a ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( sorted1061247458sorted @ a @ ( cons @ a @ x1 @ l1a ) @ ( cons @ a @ x2 @ l2b ) )
    = ( ord_less_eq @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ ( cons @ a @ x2 @ l2b ) ) ) ) ).

%------------------------------------------------------------------------------
